<?php

namespace UtillzCore\Inc\Src\Form\Modules\Repeater;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Repeater extends Module {

    public function before_construct() {
        $this->defaults += [
            'can_hide' => false,
        ];
    }

    public function controller() {

        $items = is_array( $this->props->value ) ? $this->props->value : Ucore()->json_decode( $this->props->value );

        return array_merge( (array) $this->props, [
            'items' => $items,
            'strings' => (object) [
                'add_new' => isset( $this->props->button ) ? $this->props->button['label'] : esc_html__( 'Add new', 'utillz-core' ),
                'no_modules' => esc_html__( 'No modules were found', 'utillz-core' ),
                'select' => esc_html__( 'Select module', 'utillz-core' ),
            ],
            'component' => $this->component,
            'repeater' => $this,
            'templates_num' => count( $this->props->templates ),
        ]);

    }

}
